<?= $this->extend('layouts/auth') ?>

<?= $this->section('content') ?>

<div class="container d-flex align-items-center justify-content-center min-vh-100">
    <div class="row w-100 justify-content-center">
        <div class="col-md-5 col-lg-4">
            <div class="card shadow-lg border-0" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); border-radius: 20px;">
                <div class="card-body p-4">
                    <!-- Auth Header -->
                    <div class="text-center mb-4">
                        <div class="d-inline-flex align-items-center justify-content-center bg-primary rounded-circle mb-3" style="width: 60px; height: 60px;">
                            <i class="bi bi-shield-lock text-white" style="font-size: 1.5rem;"></i>
                        </div>
                        <h3 class="text-primary fw-bold mb-2">Login Admin</h3>
                        <span class="badge bg-primary px-3 py-2"><?= esc($roleName) ?></span>
                    </div>

                    <!-- Login Form -->
                    <form action="<?= base_url('auth/login/' . $role) ?>" method="POST" id="loginForm">
                        <?= csrf_field() ?>
                        
                        <div class="mb-3">
                            <div class="input-group">
                                <span class="input-group-text bg-light border-primary">
                                    <i class="bi bi-person text-primary"></i>
                                </span>
                                <input type="text" class="form-control border-primary" id="username" name="username" placeholder="Username" required autofocus>
                            </div>
                        </div>

                        <div class="mb-4">
                            <div class="input-group">
                                <span class="input-group-text bg-light border-primary">
                                    <i class="bi bi-lock text-primary"></i>
                                </span>
                                <input type="password" class="form-control border-primary" id="password" name="password" placeholder="Password" required>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary w-100 py-2 mb-3" id="loginBtn" style="border-radius: 12px;">
                            <span class="btn-content" id="btnContent">
                                <i class="bi bi-box-arrow-in-right me-2"></i>Login
                            </span>
                            <span class="btn-loading d-none" id="btnLoading">
                                <div class="spinner-border spinner-border-sm me-2" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>Tunggu sebentar...
                            </span>
                        </button>
                    </form>

                    <!-- Footer -->
                    <div class="text-center">
                        <a href="<?= base_url('auth/login') ?>" class="btn btn-outline-primary btn-sm" onclick="console.log('Kembali Pilih Admin clicked'); return true;">
                            <i class="bi bi-arrow-left me-1"></i>Kembali Pilih Admin
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
// Show loading state on form submission
function showLoadingState() {
    const btn = document.getElementById('loginBtn');
    const btnContent = document.getElementById('btnContent');
    const btnLoading = document.getElementById('btnLoading');
    
    if (btn && btnContent && btnLoading) {
        btnContent.classList.add('d-none');
        btnLoading.classList.remove('d-none');
        btn.disabled = true;
        btn.style.pointerEvents = 'none';
        
        // Reset loading state after 3 seconds if no response (for error cases)
        setTimeout(() => {
            if (btn.disabled) {
                btnContent.classList.remove('d-none');
                btnLoading.classList.add('d-none');
                btn.disabled = false;
                btn.style.pointerEvents = 'auto';
            }
        }, 3000);
    }
}

// Pop-up Notification System
function showNotification(message, type = 'error') {
    // Remove existing notifications
    const existingNotifications = document.querySelectorAll('.notification-popup');
    existingNotifications.forEach(notif => notif.remove());
    
    // Create notification
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'error' ? 'danger' : type} position-fixed`;
    notification.style.cssText = `
        top: 20px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        max-width: 400px;
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    `;
    
    const iconMap = {
        error: 'bi-exclamation-triangle',
        success: 'bi-check-circle',
        info: 'bi-info-circle'
    };
    
    notification.innerHTML = `
        <div class="d-flex align-items-center">
            <i class="${iconMap[type]} me-2"></i>
            <div>${message}</div>
            <button type="button" class="btn-close ms-auto" onclick="this.parentElement.parentElement.remove()"></button>
        </div>
    `;
    
    document.body.appendChild(notification);
    
    // Auto hide after 4 seconds
    setTimeout(() => {
        if (notification.parentElement) {
            notification.remove();
        }
    }, 4000);
}

// Check for PHP flash messages and show as pop-up
function checkFlashMessages() {
    <?php if (session()->getFlashdata('error')): ?>
        showNotification('<?= addslashes(session()->getFlashdata('error')) ?>', 'error');
    <?php endif; ?>
    
    <?php if (session()->getFlashdata('success')): ?>
        showNotification('<?= addslashes(session()->getFlashdata('success')) ?>', 'success');
    <?php endif; ?>
}

// Show validation errors
function showValidationError(message) {
    showNotification(message, 'error');
}

// Add event listeners when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    const loginForm = document.getElementById('loginForm');
    const loginBtn = document.getElementById('loginBtn');
    
    // Check for flash messages
    checkFlashMessages();
    
    if (loginForm) {
        loginForm.addEventListener('submit', function(e) {
            const username = document.getElementById('username').value.trim();
            const password = document.getElementById('password').value.trim();
            
            // Client-side validation
            if (!username) {
                e.preventDefault();
                showValidationError('Username tidak boleh kosong!');
                return false;
            }
            
            if (!password) {
                e.preventDefault();
                showValidationError('Password tidak boleh kosong!');
                return false;
            }
            
            if (username.length < 3) {
                e.preventDefault();
                showValidationError('Username minimal 3 karakter!');
                return false;
            }
            
            if (password.length < 4) {
                e.preventDefault();
                showValidationError('Password minimal 4 karakter!');
                return false;
            }
            
            console.log('Form submitted');
            showLoadingState();
        });
    }
    
    if (loginBtn) {
        loginBtn.addEventListener('click', function(e) {
            // Validation will be handled by form submit event
        });
    }
});
</script>
<?= $this->endSection() ?>